# 即梦批量助手 - Chrome扩展

> 🎨 一个强大的浏览器插件，帮助用户在即梦平台批量提交图片生成任务
> **版本**: v1.0.0 | **更新日期**: 2025-02-04

---

## 📋 目录

- [主要功能](#主要功能)
- [最新更新](#最新更新)
- [快速开始](#快速开始)
- [参考图Tab管理](#参考图tab管理)
- [支持的格式](#支持的格式)
- [使用教程](#使用教程)
- [配置选项](#配置选项)
- [测试指南](#测试指南)
- [常见问题](#常见问题)
- [技术栈](#技术栈)
- [项目结构](#项目结构)
- [开发指南](#开发指南)

---

## ✨ 主要功能

### 核心特性

- 📂 **批量提交** - 一次性处理多个分镜，自动提交生成任务
- 🎯 **智能解析** - 支持CSV、TSV、Markdown表格、Story四种格式
- 👥 **角色提取** - 自动从分镜中提取角色名称
- 🖼️ **Tab管理** - 参考图分组管理，常驻存储，永久保存
- 💾 **原图质量** - File System Access API存储，保持原图质量，无大小限制
- 📊 **实时进度** - 可视化进度条和详细日志记录
- 🔄 **失败重试** - 智能重试机制，确保提交成功
- 🎨 **固定按钮** - 操作按钮固定底部，始终可见可操作
- 🌐 **悬浮窗界面** - 美观的渐变设计，可拖拽位置

### 新特性（v1.0.0）

- ✅ **Markdown表格支持** - 解析带HTML标签的Markdown表格
- ✅ **原图质量存储** - File System Access API + IndexedDB，保持原图质量
- ✅ **持久化权限** - 文件句柄存储，刷新后自动恢复访问权限
- ✅ **多Tab管理** - 为不同角色/场景创建专属参考图组
- ✅ **自适应高度** - 弹窗高度80vh，适配各种屏幕
- ✅ **智能缩略图** - UI显示压缩缩略图，提交使用原图

---

## 🆕 最新更新

### v1.0.0 (2025-02-04)

#### 核心升级

**1. 存储机制重大升级**
- ✅ 采用 **File System Access API** 存储文件句柄
- ✅ 使用 **IndexedDB** 持久化文件访问权限
- ✅ **原图质量保存** - 不再压缩为Base64
- ✅ **无大小限制** - 仅受用户硬盘空间限制
- ✅ UI显示智能缩略图（100x100），提交使用原图

**优势对比**:
```
旧版本: Chrome Storage + Base64
  • 容量限制: ~10MB
  • 图片质量: 压缩后的Base64
  • 刷新后: 数据仍在

新版本: File System Access API + IndexedDB
  • 容量限制: 无限制（受硬盘空间）
  • 图片质量: 原图质量（无压缩）
  • 刷新后: 自动恢复访问权限
  • 浏览器要求: Chrome 86+
```

#### 新增功能

**1. Markdown表格格式支持**
```markdown
| 镜号 | 分镜提示词 |
| :--- | :--- |
| 1 | **角色:** 女儿<br>**景别:** 近景... |
```
- ✅ 支持管道符分隔的表格
- ✅ 自动清理HTML标签（`<br>`、`<strong>`等）
- ✅ 智能识别表头和分隔线

**2. 参考图Tab管理系统**
- ✅ 创建多个Tab分组管理参考图
- ✅ 每个Tab独立存储，互不影响
- ✅ 显示Tab图片数量徽章
- ✅ 支持Tab重命名、删除、切换
- ✅ 一键清空当前Tab或所有Tabs

**3. 原图质量持久化存储**
- ✅ 使用 File System Access API 获取文件访问权限
- ✅ FileSystemFileHandle 存储在 IndexedDB
- ✅ 刷新页面后自动恢复文件访问
- ✅ 缩略图存储在 chrome.storage（UI预览）
- ✅ 提交时从文件句柄读取原图

**4. UI布局优化**
- ✅ 弹窗高度从620px增加到80vh（视口高度的80%）
- ✅ 最小高度700px，确保基础可用空间
- ✅ 按钮固定在底部，内容区独立滚动
- ✅ 三段式布局：固定顶部+滚动内容+固定按钮

#### 技术改进

**1. 文件访问权限持久化**
- **技术**: FileSystemFileHandle 可直接存储在 IndexedDB
- **优势**: 浏览器记住文件访问权限，无需重新选择
- **流程**: 选择文件 → 存储句柄 → 刷新后自动恢复
- **效果**: 真正实现"一次上传，永久使用"（原图质量）

**2. 删除提示优化**
- **优化**: 右上角垃圾桶改为红色，区分危险操作
- **优化**: 删除Tab时显示图片数量和警告信息
- **优化**: 清空所有时列出详细的删除内容

**确认提示示例**:
```
删除Tab时：
确定要删除 Tab「女儿」吗？
该Tab包含 3 张图片，删除后无法恢复。

清空所有时：
确定要清空所有 Tabs 的图片吗？
将清空以下内容：
  • 女儿: 3 张
  • 父亲: 2 张
共 5 张图片，删除后无法恢复。
```

---

## 🚀 快速开始

### 安装步骤

**1. 下载源码**
```bash
# 下载或克隆项目
cd jimeng-batch-extension_1.0.0
```

**2. 浏览器要求**
- Chrome 86 或更高版本（支持 File System Access API）
- 开启开发者模式

**3. 加载扩展**
1. 打开Chrome浏览器，访问 `chrome://extensions/`
2. 启用右上角的"开发者模式"
3. 点击"加载已解压的扩展程序"
4. 选择项目根目录 `jimeng-batch-extension_1.0.0`

**4. 准备图标**（如果缺失）
```
icons/
├── icon16.png  (16x16)
├── icon48.png  (48x48)
└── icon128.png (128x128)
```

**5. 验证安装**
- 访问 https://jimeng.jianying.com/ai-tool/image/generate
- 页面右下角出现🎨悬浮球
- 点击展开，看到操作面板
- 按F12查看Console，确认无错误

### 基础使用流程

```
1. 准备分镜文件（.txt或.csv）
   ↓
2. 访问即梦网站
   ↓
3. 点击悬浮球展开面板
   ↓
4. 上传分镜文件 → 查看解析数量
   ↓
5. 创建Tab → 上传参考图
   ↓
6. 设置范围、间隔、重试
   ↓
7. 点击"开始批量"
   ↓
8. 查看进度和日志
   ↓
9. 完成！
```

---

## 🖼️ 参考图Tab管理

### 为什么需要Tab管理？

**传统方式的痛点**:
- ❌ 每次都要重新选择参考图
- ❌ 角色多时容易选错图片
- ❌ 刷新页面后需要重新上传

**Tab管理的优势**:
- ✅ 参考图分组存储，清晰有序
- ✅ 一次上传，永久使用
- ✅ 快速切换，提高效率
- ✅ 视觉化管理，一目了然

### 创建和管理Tab

#### 1. 添加新Tab
1. 点击参考图区域右上角的 **"+"** 按钮
2. 输入Tab名称（如"女儿"、"父亲"、"场景素材"）
3. 新Tab自动成为当前激活状态

#### 2. 上传参考图
1. 确保目标Tab处于激活状态（红色高亮）
2. 点击 **"📁 添加图片 (原图)"** 按钮
3. 选择一张或多张图片（支持多选）
4. 浏览器会请求文件访问权限，点击"允许"
5. 图片自动保存，UI显示缩略图预览

**重要**:
- 图片文件名需与角色名匹配
- 文件句柄保存后，无需保留原文件在原位置
- 刷新后会自动恢复访问权限
```
分镜中写"女儿" → 文件名为"女儿.png"
分镜中写"父亲" → 文件名为"父亲.jpg"
```

#### 3. 切换Tab
- 直接点击Tab标签即可切换
- 当前Tab显示为红色渐变背景
- 图片预览区自动更新

#### 4. 删除操作

| 操作 | 方法 | 效果 |
|------|------|------|
| 删除单张图片 | 悬停图片 → 点击右上角× | 只删除该图片 |
| 清空当前Tab | 点击"清空当前"按钮 | 清空当前Tab所有图片 |
| 清空所有Tabs | 点击右上角红色🗑️ | 清空所有Tab的图片 |
| 删除Tab | 点击Tab标签上的× | 删除Tab及其所有图片 |

**安全保护**:
- 最后一个Tab无法删除
- 所有删除操作都需二次确认
- 确认弹窗显示详细的删除内容

### Tab UI说明

```
🖼️ 参考图                      [+] [🗑️]
                              添加 清空
                              新Tab 所有
┌──────────────────────────────────────┐
│ [默认 (3)]  [女儿 (5)]  [父亲 (2)]   │ ← Tab切换栏
│    灰色        红色       灰色         │   （横向滚动）
│  (未激活)   (激活)    (未激活)        │
└──────────────────────────────────────┘

[添加图片] [清空当前]  当前: 5 张

┌────────────────────────────────┐
│ [图1] [图2] [图3] [图4] [图5]  │ ← 图片预览区
│  ×    ×    ×    ×    ×       │   （横向滚动）
└────────────────────────────────┘
```

### 使用场景示例

**场景：3角色故事批量生成**

```
1. 准备阶段
   ├── 创建"女儿" Tab → 上传3张女儿参考图
   ├── 创建"父亲" Tab → 上传2张父亲参考图
   └── 创建"小鸡" Tab → 上传4张小鸡参考图

2. 批量生成
   ├── 切换到"女儿" Tab → 开始批量 → 生成女儿分镜
   ├── 切换到"父亲" Tab → 开始批量 → 生成父亲分镜
   └── 切换到"小鸡" Tab → 开始批量 → 生成小鸡分镜

3. 下次使用
   └── 直接打开扩展，所有Tab和图片都在！
```

---

## 📝 支持的格式

### 1. Markdown表格（新增）

```markdown
| 镜号 | 分镜提示词 |
| :--- | :--- |
| 1 | **角色:**<br> * 女儿<br><br>**景别:** 近景<br>**描述:** ... |
| 2 | **角色:** 父亲<br>**景别:** 中景... |
```

**特点**:
- 管道符 `|` 分隔
- 支持HTML标签（自动清理）
- 支持Markdown格式（自动转换）

### 2. CSV格式

```csv
分镜数,分镜提示词
1,"女儿在花园里玩耍\n角色: 女儿\n环境: 花园"
2,"母亲在厨房做饭\n角色: 母亲\n环境: 厨房"
```

### 3. TSV格式

```tsv
镜号	分镜
1	女儿在花园里玩耍\n角色: 女儿
2	母亲在厨房做饭\n角色: 母亲
```

### 4. 故事格式

```
故事1:
女儿在花园里玩耍
角色: 女儿
环境: 花园

故事2:
母亲在厨房做饭
角色: 母亲
环境: 厨房
```

**智能检测**: 无需手动指定格式，自动识别

---

## 📖 使用教程

### 完整工作流程

#### 步骤1：准备分镜文件

选择上述任一格式编写分镜脚本，保存为 `.txt` 或 `.csv` 文件。

#### 步骤2：创建Tab和上传参考图

**一次性配置，永久使用**

1. 点击 **"+"** 创建"女儿" Tab
2. 点击 **"添加图片"**，选择女儿的3张参考图
3. 重复创建"父亲"、"小鸡"等Tab
4. 为每个Tab上传对应参考图

**优势**:
- 下次使用直接切换Tab即可
- 图片永久保存，无需重复上传

#### 步骤3：上传分镜文件

1. 点击"📂 分镜文件"区域
2. 选择准备好的分镜文件
3. 查看日志确认解析成功
   ```
   ✅ 已加载: script.txt, 解析到 19 个分镜
   [StoryboardParser] 检测到格式: MARKDOWN
   ```

#### 步骤4：配置参数

| 参数 | 说明 | 建议值 |
|------|------|--------|
| 范围 | 处理第X到第Y个分镜 | 1 ~ 19（全部） |
| 间隔 | 每个分镜提交间隔（秒） | 3-5秒 |
| 重试 | 失败后重试次数 | 2次 |

#### 步骤5：开始批量

1. 切换到需要的Tab（如"女儿"）
2. 点击底部固定的 **"🚀 开始批量"** 按钮
3. 观察进度条和日志
4. 完成后切换Tab处理其他角色

### 使用技巧

#### 1. 参考图命名规范

**✅ 正确**:
```
女儿.png     → 匹配"女儿"
父亲.jpg     → 匹配"父亲"
小鸡_01.png  → 匹配"小鸡"（文件名包含角色名）
```

**❌ 错误**:
```
图片1.png        → 无法匹配任何角色
role_daughter.png → 无法匹配"女儿"
```

#### 2. 间隔时间设置

根据网络和服务器情况调整：
- **网速快** + 服务器空闲: 2-3秒
- **网速一般**: 4-5秒
- **服务器繁忙**: 6-10秒

#### 3. 分批处理

大批量任务建议：
- 每批10-20个分镜
- 观察成功率后继续
- 避免一次性提交过多

#### 4. Tab管理最佳实践

- **命名清晰**: 用角色名或场景名命名Tab
- **定期整理**: 删除不再使用的Tab
- **备份原图**: 虽然有常驻存储，建议保留原始图片

---

## ⚙️ 配置选项

| 选项 | 说明 | 默认值 | 推荐值 | 备注 |
|------|------|--------|--------|------|
| 提交范围 | 指定处理的分镜范围 | 1 ~ 999 | 根据实际 | 可部分处理 |
| 提交间隔 | 每个分镜间隔（秒） | 3秒 | 2-5秒 | 过快可能失败 |
| 失败重试 | 失败后重试次数 | 2次 | 1-3次 | 重试间隔3秒 |

---

## 🧪 测试指南

### 1. 图片持久化测试

**目标**: 验证刷新后图片不丢失

**步骤**:
1. 展开扩展面板
2. 创建Tab并上传2-3张图片
3. 确认图片预览正常，Tab显示数量 `(3)`
4. **按F5刷新页面**
5. 再次展开面板

**预期结果**:
- ✅ Tab仍然存在
- ✅ 图片数量显示正确
- ✅ 图片预览正常显示
- ✅ Console显示: `✅ 参考图 Tab 管理器已初始化`

**验证数据存储**:
```javascript
// 在Console中运行
chrome.storage.local.get('jimeng_reference_tabs', (result) => {
  console.log('存储的数据:', result);
});
```

### 2. 删除提示测试

**场景A - 删除含图片的Tab**:
1. 点击Tab上的×按钮
2. 验证弹窗内容：
   ```
   确定要删除 Tab「女儿」吗？
   该Tab包含 3 张图片，删除后无法恢复。
   ```

**场景B - 清空所有Tabs**:
1. 创建2个Tab，分别上传图片
2. 点击右上角红色🗑️
3. 验证弹窗显示详细列表

### 3. 固定按钮测试

**步骤**:
1. 展开面板
2. 添加多个Tab和图片
3. 查看日志区域（添加大量日志）
4. **向下滚动内容区**

**预期结果**:
- ✅ 只有内容区滚动
- ✅ 底部按钮固定不动
- ✅ 按钮始终可见可点击

### 4. Markdown解析测试

**步骤**:
1. 准备Markdown表格格式的txt文件
2. 上传到扩展
3. 查看日志

**预期输出**:
```
✅ 已加载: test.txt, 解析到 19 个分镜
[StoryboardParser] 检测到格式: MARKDOWN
[StoryboardParser] Markdown表格解析: 找到 19 个分镜
```

---

## 🐛 常见问题

### Q1: 刷新后图片消失了？

**v1.0.0 新版说明**:
- 图片不会消失！使用文件句柄持久化
- 刷新后会自动恢复文件访问权限

**可能的原因**:
- 浏览器不支持 File System Access API（需Chrome 86+）
- 原图文件被移动或删除
- 浏览器清除了IndexedDB数据

**解决方法**:
1. 检查浏览器版本: `chrome://version/`
2. 在Console运行诊断: `jimengDebug.diagnose()`
3. 查看错误日志: F12 → Console
4. 重新添加图片（如果文件已移动）

**调试工具**:
```javascript
// 查看存储状态
jimengDebug.status()

// 查看IndexedDB统计
jimengDebug.storage()

// 完全重置（清空所有数据）
jimengDebug.reset()
```

### Q2: 能存储多少张图片？

**容量（v1.0.0 新版）**:
- **原图存储**: 无限制（仅受硬盘空间限制）
- **缩略图存储**: chrome.storage 约10MB
- **实际限制**: 取决于chrome.storage中的缩略图数量

**建议**:
- 单张图片: 无限制（保持原图质量）
- 单Tab: 建议 ≤100张（考虑UI性能）
- 总计: 建议 ≤200张

**注意**:
- 原图通过文件句柄访问，不占用chrome.storage
- 只有缩略图（100x100）存储在chrome.storage
- 每个缩略图约10-20KB

### Q3: 参考图未上传？

**检查**:
- 文件名与角色名匹配
- 图片格式支持（png/jpg/jpeg/webp）
- 查看日志警告信息

**日志示例**:
```
⚠️ 缺少参考图: 女儿
```

### Q4: 提示"提交失败"但实际成功了？

**已优化**:
- ✅ 超时时间15秒（原10秒）
- ✅ 超时时检查按钮状态
- ✅ 默认超时视为成功

### Q5: 看不到悬浮球？

**解决**:
- 刷新页面（F5）
- F12查看Console错误
- 确认URL是 `jimeng.jianying.com`
- 查看是否有"即梦批量助手已加载"

### Q6: 按钮是灰色的？

**"开始批量"灰色**:
- 未上传分镜文件 → 先上传文件

**"暂停"灰色**:
- 任务未运行 → 开始后自动启用

---

## 🔧 技术栈

### 核心技术

- **Manifest V3** - Chrome扩展最新规范
- **Vanilla JavaScript** - 无框架，轻量高效
- **Chrome Extension APIs**:
  - `chrome.storage.local` - 缩略图和配置持久化
  - `chrome.downloads` - 文件下载
  - `chrome.runtime` - 消息通信
- **Web APIs**:
  - `File System Access API` - 文件访问权限管理（**核心**）
  - `IndexedDB` - FileSystemFileHandle 持久化存储
  - `MutationObserver` - 监听DOM变化
  - `DataTransfer` - 模拟文件拖拽
  - `FileReader` - 读取文件内容
  - `Canvas API` - 生成缩略图

### 第三方库

- **PapaParse** - CSV解析库（本地化）

### 架构特点

- **模块化设计** - 功能独立，易于维护
- **双层存储架构** - IndexedDB（原图句柄） + chrome.storage（缩略图）
- **Flexbox布局** - 响应式UI，自适应高度
- **事件驱动** - 高效的异步处理
- **权限持久化** - 文件访问权限自动恢复

---

## 📦 项目结构

```
jimeng-batch-extension_1.0.0/
├── manifest.json                    # 扩展配置 (Manifest V3)
├── icons/                           # 图标资源
│   ├── icon16.png
│   ├── icon48.png
│   └── icon128.png
├── content/                         # 页面注入脚本
│   ├── content.js                  # 主入口（悬浮窗+事件）
│   ├── content.css                 # 样式文件
│   └── modules/                    # 功能模块
│       ├── storyboard-parser.js    # 分镜解析（4种格式）
│       ├── role-extractor.js       # 角色提取（正则）
│       ├── file-picker.js          # 文件选择器封装（NEW）
│       ├── file-handle-storage.js  # 文件句柄存储（NEW）
│       ├── thumbnail-generator.js  # 缩略图生成器（NEW）
│       ├── reference-tabs-manager.js # Tab管理（升级）
│       ├── image-uploader.js       # 参考图上传
│       ├── submit-handler.js       # 提交流程控制
│       ├── image-downloader.js     # 图片下载
│       └── dom-helper.js          # DOM工具函数
├── background/                      # 后台服务
│   └── background.js               # Service Worker
├── lib/                            # 第三方库
│   └── papaparse.min.js           # CSV解析
├── CLAUDE.md                       # 开发者指南
└── README.md                       # 本文档
```

---

## 🛠️ 开发指南

### 调试方法

**1. Content Script**:
- 在即梦页面按F12
- Console标签查看日志
- 筛选 `[模块名]` 前缀

**2. Popup UI**:
- 右键扩展图标
- "检查弹出内容"

**3. Background**:
- `chrome://extensions/`
- 点击"Service Worker"

### 模块说明

**新增模块（v1.0.0）**:

1. **file-picker.js** - File System Access API 封装
   - 使用 `showOpenFilePicker()` 选择文件
   - 返回 FileSystemFileHandle 和 File 对象
   - 支持多选和文件类型过滤

2. **file-handle-storage.js** - IndexedDB 文件句柄存储
   - 存储 FileSystemFileHandle 到 IndexedDB
   - 验证和恢复文件访问权限
   - 按Tab分组管理文件句柄

3. **thumbnail-generator.js** - 智能缩略图生成
   - 生成 100x100 压缩预览图
   - 保持宽高比
   - 转换为 Base64 存储

4. **reference-tabs-manager.js** - Tab管理器（升级版）
   - 使用文件句柄存储原图
   - 缩略图存储在 chrome.storage
   - 提交时读取原图文件

### 选择器维护

即梦网站更新可能导致选择器失效，需更新：

| 功能 | 文件位置 |
|------|---------|
| 提示词输入框 | `submit-handler.js:138-143` |
| 提交按钮 | `submit-handler.js:197-202` |
| 参考图上传区 | `image-uploader.js:92-96` |
| 参考图项目 | `submit-handler.js:95-99` |

**更新流程**:
1. F12检查实际DOM结构
2. 更新选择器数组
3. 重新加载扩展测试

### 本地测试

```bash
# 重新加载扩展
chrome://extensions/ → 刷新图标

# 查看日志
F12 → Console → 筛选 "[即梦批量助手]"

# 测试Tab存储
chrome.storage.local.get('jimeng_reference_tabs', console.log)
```

### 贡献指南

欢迎提交Issue和Pull Request！

**提交前确保**:
- ✅ 代码符合项目风格
- ✅ 添加必要注释
- ✅ 测试功能正常
- ✅ 更新相关文档

---

## 📊 版本历史

### v1.0.0 (2025-02-04) - 当前版本

**核心升级**:
- 🚀 **File System Access API** - 文件访问权限持久化
- 🚀 **IndexedDB** - FileSystemFileHandle 存储
- 🚀 **原图质量保存** - 不再压缩为Base64
- 🚀 **无容量限制** - 仅受硬盘空间限制
- 🚀 **智能缩略图** - UI预览用，提交用原图

**新增功能**:
- ✨ Markdown表格格式支持
- ✨ 参考图Tab管理系统
- ✨ 文件选择器封装（file-picker.js）
- ✨ 文件句柄存储（file-handle-storage.js）
- ✨ 缩略图生成器（thumbnail-generator.js）
- ✨ 固定底部按钮
- ✨ 自适应弹窗高度（80vh）

**技术改进**:
- 🔧 双层存储架构（IndexedDB + chrome.storage）
- 🔧 权限自动恢复机制
- 🔧 调试工具集成（jimengDebug）

**UI优化**:
- 🎨 弹窗高度700-1700px自适应
- 🎨 底部按钮固定，内容区滚动
- 🎨 删除按钮红色警示
- 🎨 详细的二次确认提示
- 🎨 "添加图片 (原图)" 按钮标注

**其他**:
- ✅ 智能格式检测（CSV/TSV/Markdown/Story）
- ✅ 角色提取和参考图上传
- ✅ 进度显示和日志记录
- ✅ 失败重试机制（15秒超时）
- ✅ 动态版本号显示

**浏览器要求**:
- ⚠️ Chrome 86+ （File System Access API）

---

## 🎨 界面设计

### 悬浮球
- 红色渐变背景 (#ff6b6b → #c44569)
- 上下浮动动画（3秒循环）
- 鼠标悬停放大效果
- 可自由拖拽

### 面板布局
```
┌────────────────────────┐
│  🎨 即梦批量助手 v1.0.0 │ ← Header (固定)
├────────────────────────┤
│  📂 分镜文件           │ ↑
│  🖼️ 参考图 [Tab]      │ │
│  ⚙️ 设置              │ │ Content
│  📊 进度               │ │ (滚动)
│  📋 日志...            │ ↓
├────────────────────────┤
│  🚀 开始批量 ⏸️ 暂停   │ ← Footer (固定)
└────────────────────────┘
```

### 日志颜色
- 🟢 **绿色**: 成功操作
- 🔴 **红色**: 失败错误
- 🟡 **黄色**: 警告提示
- ⚪ **灰色**: 信息日志

---

## 📄 许可证

本项目采用 MIT 许可证，仅供学习交流使用。

请遵守即梦平台的使用条款和服务协议。

---

## 🙏 致谢

- [PapaParse](https://www.papaparse.com/) - CSV解析库
- 即梦平台 - 提供AI图片生成服务
- Chrome Extensions - 强大的扩展API

---

**项目维护**: Claude Code
**当前版本**: v1.0.0
**更新日期**: 2025-02-04
**文档版本**: v1.0.0
**浏览器要求**: Chrome 86+

---

## 📮 联系方式

如有问题或建议，欢迎通过以下方式联系：
- 提交 Issue
- 发起 Pull Request
- 查看 `CLAUDE.md` 了解开发细节
