# 示例文件使用说明

本目录包含4个示例文件，展示即梦批量助手支持的4种分镜文件格式。

## 📄 文件列表

### 1. 示例文件-CSV格式.csv
- **格式**: CSV (逗号分隔)
- **特点**:
  - 使用逗号分隔字段
  - 支持多行内容（使用引号包裹）
  - 适合Excel编辑
- **使用场景**: 需要在Excel中编辑分镜脚本

### 2. 示例文件-Markdown格式.txt
- **格式**: Markdown表格
- **特点**:
  - 使用管道符 `|` 分隔列
  - 支持HTML标签（如 `<br>` 换行）
  - 支持Markdown格式（如 `**粗体**`）
  - 可读性强
- **使用场景**: 使用Markdown编辑器编写脚本

### 3. 示例文件-TSV格式.txt
- **格式**: TSV (制表符分隔)
- **特点**:
  - 使用Tab键分隔字段
  - 支持多行内容
  - 适合文本编辑器
- **使用场景**: 使用记事本或文本编辑器编写脚本

### 4. 示例文件-Story格式.txt
- **格式**: 故事分隔符格式
- **特点**:
  - 使用"故事1:"、"故事2:"等作为分隔符
  - 自由文本格式
  - 最简单直观
- **使用场景**: 快速编写简单分镜

## 🎯 内容说明

所有示例文件包含相同的10个分镜场景：
1. 女儿在花园里玩耍
2. 父亲在书房工作
3. 女儿向父亲展示画作
4. 小鸡在院子里觅食
5. 母亲在厨房做饭
6. 全家人围坐餐桌
7. 女儿喂小鸡
8. 父亲教女儿骑自行车
9. 母亲给女儿梳头发
10. 女儿在画画

## 👥 角色列表

示例中包含以下角色：
- **女儿** - 小女孩，粉色连衣裙
- **父亲** - 中年男子，戴眼镜
- **母亲** - 温柔女性，围围裙
- **小鸡** - 黄色毛茸茸的小鸡

## 📁 准备参考图

为了配合这些示例使用，你需要准备以下参考图：

```
参考图文件夹/
├── 女儿.png     (或 .jpg / .webp)
├── 父亲.png
├── 母亲.png
└── 小鸡.png
```

**重要**: 文件名必须与角色名完全匹配！

## 🚀 使用步骤

1. **选择格式**
   - 根据你的编辑习惯选择一种格式

2. **准备分镜文件**
   - 复制对应的示例文件
   - 根据你的需求修改内容
   - 保持格式结构不变

3. **准备参考图**
   - 按角色名命名图片文件
   - 推荐使用原图质量（v1.0.0支持）

4. **使用扩展**
   - 打开即梦网站
   - 点击悬浮球展开面板
   - 上传分镜文件
   - 创建Tab并上传参考图
   - 开始批量提交

## ⚙️ 格式转换

如果需要转换格式：

- **CSV → Markdown**: 在Excel中打开CSV，复制到Markdown表格生成器
- **Markdown → CSV**: 使用在线Markdown表格转CSV工具
- **Story → CSV**: 手动整理，或使用文本处理脚本

## 📝 自定义分镜

编写自己的分镜时，建议包含以下信息：

```
角色: [角色名称，用逗号分隔]
景别: [近景/中景/全景/特写]
描述: [详细的场景描述]
```

**提示**: 描述越详细，AI生成的图片质量越好！

## 🔍 格式自动检测

即梦批量助手会自动检测文件格式，你无需手动指定。检测逻辑：

1. 检测Markdown表格特征（管道符 + 分隔线）
2. 检测CSV特征（引号 + 逗号）
3. 检测TSV特征（制表符）
4. 默认使用Story格式

## ⚠️ 注意事项

1. **编码格式**: 所有文件使用 UTF-8 编码
2. **文件扩展名**: CSV用`.csv`，其他用`.txt`
3. **角色名匹配**: 参考图文件名必须与分镜中的角色名一致
4. **内容长度**: 单个分镜建议不超过500字
5. **特殊字符**: 避免使用特殊符号，可能影响解析

## 🆘 遇到问题？

如果文件无法解析：
1. 检查文件编码是否为UTF-8
2. 检查格式是否符合示例
3. 查看浏览器Console日志
4. 参考README.md中的"常见问题"部分

---

**提示**: 建议先使用示例文件测试，熟悉流程后再创建自己的分镜文件。
