// ==================== 内容脚本 - 注入到用户网站 ====================

// 监听来自页面的消息
window.addEventListener('message', async (event) => {
    if (event.source !== window) return;

    // 请求抓取所有网站
    if (event.data.type === 'OUTLIER_SCRAPE_REQUEST') {
        try {
            const response = await chrome.runtime.sendMessage({ action: 'scrapeAll' });
            window.postMessage({
                type: 'OUTLIER_SCRAPE_RESPONSE',
                success: true,
                data: response
            }, '*');
        } catch (error) {
            window.postMessage({
                type: 'OUTLIER_SCRAPE_RESPONSE',
                success: false,
                error: error.message
            }, '*');
        }
    }

    // 请求读取缓存（不触发新抓取）
    if (event.data.type === 'OUTLIER_CACHE_REQUEST') {
        try {
            const stored = await chrome.storage.local.get('lastScrape');
            if (stored.lastScrape) {
                window.postMessage({
                    type: 'OUTLIER_CACHE_RESPONSE',
                    success: true,
                    data: stored.lastScrape
                }, '*');
            } else {
                window.postMessage({
                    type: 'OUTLIER_CACHE_RESPONSE',
                    success: false,
                    error: '缓存为空'
                }, '*');
            }
        } catch (error) {
            window.postMessage({
                type: 'OUTLIER_CACHE_RESPONSE',
                success: false,
                error: error.message
            }, '*');
        }
    }

    // 更新缓存（存储完整视频详情）
    if (event.data.type === 'OUTLIER_CACHE_UPDATE') {
        try {
            const newData = event.data.data;
            await chrome.storage.local.set({ lastScrape: newData });
            window.postMessage({
                type: 'OUTLIER_CACHE_UPDATE_RESPONSE',
                success: true
            }, '*');
            console.log('[扩展] 缓存已更新，包含', newData.videos?.length || 0, '个视频');
        } catch (error) {
            window.postMessage({
                type: 'OUTLIER_CACHE_UPDATE_RESPONSE',
                success: false,
                error: error.message
            }, '*');
        }
    }
});

// 通知页面扩展已加载
window.postMessage({ type: 'OUTLIER_EXTENSION_READY' }, '*');
console.log('爆款视频抓取器扩展已加载');
